//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

char *Server::PeekSendData(int Client)
{
    return SendData[Client];
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int Server::PeekSizeOfSendData(int Client)
{
    return SizeOfSendData[Client];
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

char *Server::PeekReceiveData(int Client)
{
    return ReceiveData[Client];
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int Server::PeekSizeOfReceiveData(int Client)
{
    return SizeOfReceiveData[Client];
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD ThreadWaitForDisconnect(Server *pServer, int Client)
{
    if(pServer->Connected[Client])
    {
        pServer->Disconnect[Client] = true;

        while(pServer->Connected[Client])
        {
            // Waiting for client to be disconnected
            Sleep(1);
        }
    }

    FreeSingleClientInfo(Client);

    CloseHandle(pServer->Client_Thread_Handle[Client]);
    pServer->Client_Thread_ID[Client] = 0;
    pServer->IsClientThreadActive[Client] = false;

    return 0;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Server::IsDataReady(int xClient)
{
    if(SizeOfReceiveData[xClient] > 0)
        return true;

	return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Server::GetReceiveData(int xClient, char *rBuffer, int *Size)
{
    if(SizeOfReceiveData[xClient] <= 0)
    {
        *Size = 0;
        return false;
    }

    if(RawMode[xClient] == true)
    {
        memcpy(rBuffer, ReceiveData[xClient], SizeOfReceiveData[xClient]);
        *Size = SizeOfReceiveData[xClient];
        FreeClientReceive(xClient);
        return true;
    }
    else{

        ReceiveData[xClient][SizeOfReceiveData[xClient]] = '\0';

        *Size = BreakRecvPacket(rBuffer, ReceiveData[xClient], SizeOfReceiveData[xClient], &RecvOffset[xClient]);
        if(*Size == -1)
        {
            Disconnect[xClient] = true;
            *Size = 0;
            return false;
        }

        if(RecvOffset[xClient] == -1)
            FreeClientReceive(xClient);

    	return true;
    }

    return false; // should never get here
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Server::SetSendDataEx(int xClient, char *String, int Size)
{
    if(SizeOfSendData[xClient] > 0)
        return false;

    SendData[xClient] = (char *) calloc(Size + 1, 1);
    memcpy(SendData[xClient], String, Size);
    SizeOfSendData[xClient] = Size;
	return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Server::SetSendData(int xClient, char *String)
{
    return SetSendDataEx(xClient, String, strlen(String));
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int Server::SelectFreeClient(void)
{
	int xClient = 0;

    if(Connections >= giMaxConnections)
        return -1;

	while(xClient < MAXCLIENTS)
	{
		if( Connected[xClient] == false && IsClientThreadActive[xClient] == false)
            return xClient;

		xClient++;
	}

	return -1;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Server::FreeClientSend(int xClient)
{
    if( SendData[xClient] ) free( SendData[xClient] );
	SendData[xClient]		  = NULL;
	SizeOfSendData[xClient]	  = 0;
	return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Server::FreeClientReceive(int xClient)
{
	if( ReceiveData[xClient] ) free( ReceiveData[xClient] );
	ReceiveData[xClient] 	   = NULL;
	SizeOfReceiveData[xClient] = 0;
	return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Server::FreeClientSendReceive(int xClient)
{
	FreeClientSend(xClient);
	FreeClientReceive(xClient);
	return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Server::DisconnectClient(int xClient)
{
	Disconnect[xClient] = false;

    if(Connected[xClient] == false)
        return false;

    char StatusTemp[255];

    sprintf(StatusTemp, "(%d) Disconnected client[%d].", ClientID[xClient], xClient);
    WriteLog(StatusTemp);

	WSASendDisconnect(Socket[xClient], NULL);
	shutdown(Socket[xClient], SD_BOTH);
	closesocket(Socket[xClient]);

	FD_CLR(Socket[xClient], &ReadFDS);
	FD_CLR(Socket[xClient], &WriteFDS);
	FD_CLR(Socket[xClient], &ExceptFDS);

	FreeClientSendReceive(xClient);

	WSARecvDisconnect(Socket[xClient], NULL);

    RecvOffset[xClient] = -1;
    DisconnectTime[xClient] = -1;

	Disconnect[xClient] = false;
	Connected[xClient]  = false;
    RawMode[xClient]    = false;
	Connections--;
    glConnections--;

	return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int Server::RawWriteClientEx(int xClient, char *Data, int Size)
{
	return send(Socket[xClient], Data, Size, 0);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int Server::WriteLineToClientEx(int xClient, char *LineToSend, int Length)
{
    if(RawMode[xClient] == true)
    {
		return send(Socket[xClient], LineToSend, Length, 0);
	}
	else{
		char SendData[MaxReceiveSize];
		int SendLen = MakeSendPacket(SendData, LineToSend, Length);
		//Encode(&BaseCommCript, SendData, SendData, SendLen);
		return send(Socket[xClient], SendData, SendLen, 0);
	}
	return -1; // Should never get here
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int Server::WriteLineToClient(int xClient, char *LineToSend)
{
	return WriteLineToClientEx(xClient, LineToSend, strlen(LineToSend));
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

